
# Exercise 2.3 - RSA Key Recovery

In this exercise, we will extract an RSA key from a *square-and-multiply* RSA implementation, which has some countermeasures against timing side channels deployed. Similar to episode 2.3, we try to extract the key from Claudio's test system after the assignment deadline has expired. Luckily we have the binary and the RSA library of the system available. 

We also know that the `square-and-multiply` algorithm looks as follows:

```c++
// compute: c = m^e mod N
integer encrypt(integer m, integer e, integer N) {
    integer c = init("1");
    for ( size_t i = 0; i < bits(e); ++i ) {
        if ( bit(e, i) ) {
            square(c, c);
            multiply(c, c, m);
        }
        else {
            square(c, c);
        }
        modulo(c, c, N);
        // Claudio's mitigation against timing attacks
    }
    return c;
}
```

However, we don't know what the mitigation looks like.

# Tasks

## Task 1:
Find the offset of the `square` and `multiply` functions using `readelf` on `system/librsa.so`.

## Task 2: 
Use these offsets combined with your flush and reload implementation from 2.2 (the previous exercise) to recover the full RSA key. Your goal is to implement a spy in [spy.cpp](spy.cpp) that runs in parallel during the execution of Claudio's test system. The spy maps the same shared RSA library ([librsa.so](system/librsa.so)) as the test system and performs flush and reload on it. 

You can trigger the signing process of Claudio's test system by executing:

```
./system/system
```

This command will start to sign you *exercise* but has a check for the deadline and will fail.

# Retriving the PIN to Solve the Exercise on EDX

We also provide you with the `verify` binary. This binary takes a `SMSM...` string and gives you the PIN to enter on the EDX site.
We implemented a similarity check, so if your guess has less than `8` errors, i.e., is near the correct result, you will receive the EDX PIN.
Note: Do not enter the `SMSM...` string on EDX.

```
./verify SMSM
key distance >= 8, key not similar enough! 
```

If the correct SM-key is provided the output will look something like this.

```
./verify **GUESS**
here is the pin: *****
```


# Tipps and Notes:

## Fix the CPU's frequency
Similar to the last exercise, we recommend fixing the CPU to a given frequency:

```
sudo cpupower frequency-set -d 3GHz -u 3Ghz   
```

## Use taskset
You can use the `taskset` program to fix another program to a given core. For example, the following command set the test system to core 1:

```
taskset -c 1 ./system
```

This command restricts the operating system from scheduling the program to a different core, removing potential noise.

## Use the provided functions
Look through the skeleton we provided, it already contains necessary code which should be used in the exercise ([spy.cpp](spy.cpp) and [scs_lib.h](scs_lib.h))

## Flush and Reload
Consider delaying the attacker loop, as executing flush and reload in an endless loop might be counterproductive. Think about why!