#include <cassert>
#include <cstdio>
#include <fcntl.h>
#include <pthread.h>
#include <sched.h>
#include <stdint.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>

// returns a 64-bit counter value from rdtsc
uint64_t read_timestamp_counter() {
    uint64_t a, d;
    asm volatile("mfence");
    asm volatile("rdtsc" : "=a"(a), "=d"(d));
    a = (d << 32) | a;
    asm volatile("mfence");
    return a;
}

// map a shared library to the process virtual address space
uint8_t *open_shared(const char *name) {
    int fd = open(name, O_RDONLY);
    assert(fd >= 0 && "error opening shared library!");

    struct stat s;

    int ret = fstat(fd, &s);
    assert(ret >= 0 && "fstat failed!");

    void *address = mmap(nullptr, s.st_size, PROT_READ, MAP_SHARED, fd, 0);
    assert(address != MAP_FAILED && "mmap failed!");

    printf("mapped shared library '%s' to %p\n", name, address);

    return (uint8_t *)address;
}

// flushes the pointer from the cache
void flush(void *p) {
    asm volatile("clflush 0(%0)\n" : : "c"(p) : "rax");
}

// performs a memory access on the pointer
void maccess(void *p) {
    asm volatile("movq (%0), %%rax\n" : : "c"(p) : "rax");
}

// wait for a certain number of clock cycles
void delay(uint64_t delay) {
    uint64_t current = read_timestamp_counter();
    while ( read_timestamp_counter() < current + delay )
        ;
}

//////////////////////////////////////////////////////////////////////
// Start of TODOs

bool flushandreload(void *p) {
    // TODO: reuse the implementation from 2.2
    return false;
}