
# Exercise 2.4 - AES Key Recovery

This exercise will extract an AES key from the OpenSSL T-table implementation. In contrast to the Episode, we will focus on only the first row of the shown matrix. This exercise aims to perform a first-round Flush & Reload attack on the implementation.

# Tasks

## Task 0:
Reuse our previous Flush & Reload implementation and thresholds.

## Task 1:
Find the offset of the T-tables `Te0`, `Te1`, `Te2`, and `Te3` symbols using `readelf` on `libaes.so` and add them to the `get_ttable_address` function.

## Task 2:
Examine how the key and the T-tables interact during the first round and implement the T-table selection function in `get_ttable_address`. Distinct key bytes interact with different T-tables. Therefore, we must select the correct T-table depending on the key byte we want to recover.

The following code snippet shows the first round of the AES T-table implementation:

```c
t0 = Te0[key[ 0] ^ pt[ 0]] ^ Te1[key[ 5] ^ pt[ 5]] ^ Te2[key[10] ^ pt[10]] ^ Te3[key[15] ^ pt[15]] ^ ...
t1 = Te0[key[ 4] ^ pt[ 4]] ^ Te1[key[ 9] ^ pt[ 9]] ^ Te2[key[14] ^ pt[14]] ^ Te3[key[ 3] ^ pt[ 3]] ^ ...
t2 = Te0[key[ 8] ^ pt[ 8]] ^ Te1[key[13] ^ pt[13]] ^ Te2[key[ 2] ^ pt[ 2]] ^ Te3[key[ 7] ^ pt[ 7]] ^ ...
t3 = Te0[key[12] ^ pt[12]] ^ Te1[key[ 1] ^ pt[ 1]] ^ Te2[key[ 6] ^ pt[ 6]] ^ Te3[key[11] ^ pt[11]] ^ ...
```

## Task 3:
For this task, we first take a look at one of the T-table accesses of the implementation:

```C
Te0[key[ 0] ^ pt[ 0]]
```

We see that, if the `key[0]` matches `pt[0]` the xor operation will return `0` and index `Te0[0]`. A single T-table entry consists of four bytes, resulting in 16 entries per cache line. So if we observe a cache hit at the zeroth line (64 byte) address of `Te0[x]`, we know that `0 <= x < 16`. Therefore, we can recover `0 <= key[0] ^ pt[0] < 16`.
This bound allows us to recover the upper 4 bits of each key byte.

Note: For the exercise, it is enough to recover the upper 4 bits of each key byte. The remaining bits are provided in the [spy.cpp](spy.cpp) file.

Your task is to implement Flush & Reload on the corresponding zeroth T-table entry of each key byte in the `perform_one_round` function and return true if you observe a cache hit.

## Statistics
In the previous section, we observed that accesses to the zeroth T-table entry contain much information. However, these accesses might not be unique given a plaintext, i.e., a single cache hit to the zeroth T-table must not directly leak the key.
However, if we repeat the experiment for different plaintexts where we only fix a single byte for the key byte we want to extract, we will observe more than 95% of cache hits on the T-table entry where the upper 4 bits of the plaintext byte match the key byte.
This step is already implemented in the `recover_key_byte` function.

# Retrieving the PIN to Solve the Exercise on EDX

If the recovered key matches the AES key, the spy tool will print you a Flag.
The flag starts with "Flag: " followed by 10 characters:

"Flag: xxxxxxxxxx"

Enter the ten characters (without "Flag: ") on EDX to pass the exercise.

# Tipps and Notes:

## Fix the CPU's frequency
Similar to the last exercise, we recommend fixing the CPU to a given frequency:

```
sudo cpupower frequency-set -d 3GHz -u 3Ghz   
```

## Use taskset
You can use the `taskset` program to fix another program to a given core. For example, the following command set the test system to core 1:

```
taskset -c 1 ./system
```

This command restricts the operating system from scheduling the program to a different core, removing potential noise.

## Use the provided functions
Look through the skeleton we provided, it already contains necessary code which should be used in the exercise ([spy.cpp](spy.cpp) and [scs_lib.h](scs_lib.h))
