#ifndef libcachesim_h__
#define libcachesim_h__
#include <stdint.h>
#include <array>

namespace cachesim
{
  extern void access(uint64_t virtual_addr); //access the virtual address
  extern bool measuredAccess(uint64_t virtual_addr); //access the virtual address and determine if it was a cache hit
  extern std::array<unsigned, 8> getSets(); //tells you the cache sets the sender uses, format = set_number*slice_number
  extern void transmit(); //makes the sender transmit on all sets once
  extern void enableStage2(bool set); //enable stage 2 with noisy transmission for the second flag. default = false
  extern uint64_t getPhysicalAddr(uint64_t virtual_addr); //translate virtual address to a (pseudo-) physical address

}

#endif  // libcachesim_h__