#include "libcachesim.h"
#include <iostream>
#include <array>

using std::cout;
using std::array;

#define CACHELINE_BITS 6
#define LINE_BITS 15
#define WAY_BITS 4
#define N_SLICES 4
#define N_LINES (1 << LINE_BITS)
#define N_WAYS (1 << WAY_BITS)
#define N_SETS (N_LINES / N_WAYS)

#define SLICE0 0x1B5F575440ULL
#define SLICE1 0x2EB5FAA880ULL
#define SLICE2 0x3CCCC93100ULL

//calculate the slice index from the physical address
unsigned getSlice(uint64_t phys_addr)
{
  int slice = 0;
  if (N_SLICES >= 2)
  {
    slice = __builtin_popcountll(phys_addr & SLICE0) % 2;
    if (N_SLICES >= 4)
    {
      slice |= (__builtin_popcountll(phys_addr & SLICE1) % 2) << 1;
      if (N_SLICES >= 8)
      {
        slice |= (__builtin_popcountll(phys_addr & SLICE2) % 2) << 2;
      }
    }
  }
  return slice;
};

//calculate the set index from the physical address
unsigned getSet(uint64_t phys_addr)
{
  //TODO
  return 0;
}


//generate addresses for a given cache set and slice by searching through some memory
uint64_t* generateSet(unsigned set, unsigned slice, char* buffer)
{
  //TODO

  return NULL;
}


/*
In this task, you are building a receiver to a Prime+Probe Cache Covert Channel.
It is a simple time-based covert channel transmitting 1 byte per second.
We already provide you with a working sender, you just need to write the receiver and obtain the secret that is transmitted.
As Prime+Probe heavily depends on the hardware, this exercise uses a cache simulator based on the L3 cache of standard Intel CPUs of recent years.

You need to build a receiver that can read the 30 byte ASCII Flags.
This task has 2 stages with 2 Flags, formated like this: FLAG{..}.
In the first stage, the receiver transmits without errors or noise.
The second stage adds noise and errors, the priming in the transmit() function will be less reliable than before.

At the start of each run, the sender will randomly pick cache sets to transmit on, you can find them via the getSets() function. They are sorted from LSB to MSB.
The sender transmits one byte per second.
It transmit this byte in parallel, one bit per cache set.
For each bit which is set, the sender <emph>primes</emph> the corresponding set.
It only transmits when the transmit() function is called, you can call it as often as you like.

You will first need to find addresses in your address space that map to the same slices and sets as the sender uses.
For this, you can, e.g., malloc some memory and search through it for addresses with matching set/slice.

Once you have your addresses, you can use the measuredAccess() function to determine evictions and start receiving!

For stage 2, consider that sometimes noise will cause evictions in the cache.
Additionally, the sender might not always succeed in evicting a set fully.
You will need to find a way to work around this uncertainty.
*/
int main(){

  //the sender will let you know which random 8 sets it will use for this transmission
  array<unsigned, 8> set_numbers = cachesim::getSets();

  for (size_t i = 0; i < set_numbers.size(); i++)
  {
    std::cout << "slice: " << set_numbers[i]/N_SETS << " set: " << set_numbers[i]%N_SETS << "\n";
  }


  //stage 1 lets you try your eviction set without noise and give you the first of 2 flags
  cachesim::enableStage2(false);


  //the sender will transmit one byte per second
  time_t program_start = time(0);

  //this function causes the sender to transmit once on its sets
  //the transmitted byte depends on the current second
  //you may call this as often as you like
  cachesim::transmit();
   
  return 0;
}