#include <stdint.h>
#include <sched.h>

// returns a 64-bit counter value from rdtsc
uint64_t read_timestamp_counter() {
  uint64_t a, d;
  asm volatile ("mfence");
  asm volatile ("rdtsc" : "=a" (a), "=d" (d));
  a = (d<<32) | a;
  asm volatile ("mfence");
  return a;
}

//flushes the pointer from the cache 
void flush(void* p) { 
    asm volatile("clflush 0(%0)\n" : : "c"(p) : "rax"); 
}

// performs a memory access on the pointer
void maccess(void* p) { 
    asm volatile("movq (%0), %%rax\n" : : "c"(p) : "rax"); 
}


size_t flushandreload(void* p) {
    // TODO: implement flush and reload here
    // using the provided functions
    size_t start = read_timestamp_counter();
    maccess(p);
    size_t end = read_timestamp_counter();
    //printf("%zu\n", end - start);

    return (end - start) < 200;

}