# Exercise 4.5 - Prefetch Side-Channel

In this exercise, you will write a KASLR break using the prefetch side channel, which allows you to distinguish between present and not-present pages.

# Task

Find the base address of the currently running linux kernel (kernel text mapping, above 0xffffffff80000000) using the in the episode discussed prefetch side channel.

# Validating the result

You can check your recovered kernel base with the verify binary by running `./verify <address>` where `<address>` is the found kernel base in hexadecimal.
If the address is correct, it will print the flag.
The flag format is `Flag{XXXXXXXXXXXXX}` where X are ascii characters.


# Tipps and Notes:

## Test with known addresses

Test your attack with known user space addresses and plot the prefetch timings before running it on the unkown kernel.
Use at least one known present page/address (for example `&main`) and one known not-present page/address (for example 0x1234).

## Instruction reordering

To avoid reordering of the `prefetch` instruction you can surround it with the `mfence` instruction.

## Fix the CPU's frequency
To avoid reordering of the `prefetch` instruction, you can surround it with the `mfence` instruction.

```
sudo cpupower frequency-set -d 3GHz -u 3Ghz   
```
Fixing the frequency will result in more consistent timing measurements.

## Use taskset
You can use the `taskset` program to fix a program to a given core. For example, the following command pins your program to core 1.

```
taskset -c 1 ./<your exploit>
```

This command restricts the operating system from scheduling the program to a different core, removing potential noise.
