#include "cacheutils.h"

#include <cstdint>
#include <cstdio>
#include <cstring>
#include <pthread.h>
#include <setjmp.h>
#include <signal.h>

// length of the secret message
constexpr uint64_t NUMBER_CHARS = 20;

// use this external oracle for flush an reload
extern uint8_t volatile oracle[256 * 4096];

// the long jump buffer to recover from a seg-fault
// use longjmp and setjmp in this assignment
static jmp_buf longjump;

// address of the target buffer
static uint8_t volatile *kernel_address = (uint8_t volatile *)0x7f1234560000;

// signal handler for the segfault
static void signal_handler(int signum) {
    // TODO use longjmp to recover from a seg-fault: (see: longjmp)
}

#define MIX_I(_x) ((((_x)*167) + 13) & 255)

// reuse your flush and reload implementation to determine the accessed oracle loaction
static char do_flush_and_reload() {

    // TODO: perform flush and reload on the oracle buffer to determine the accessed page
    // TODO: use the MIX_I macro to confuse the prefetcher and reduce the nouse

    for ( uint64_t k = 0; k < 256; ++k ) {
        uint64_t i = MIX_I(k);

        if ( 0 /* TODO */ ) {
            return (char)i;
        }
    }
    return '.';
}

int main() {
    // local buffer for the recovered message
    char message[NUMBER_CHARS + 1] = {};

    // TODO: register the a signal handler for the signal 'SIGSEGV' (see: signal) and use the 'signal_handler' function as handler

    // iterate over each character
    for ( uint64_t i = 0; i < NUMBER_CHARS; ++i ) {

        // use setjump to perform a checkopoint
        if ( setjmp(longjump) == 0 ) {
            // TODO: implement meltdown access to the bytes of kernel_address + i
            // TODO: linear encode (b * x) the leaked byte in the 'oracle'
        }

        // recover the character
        message[i] = do_flush_and_reload();
    }

    printf("%s\n", message);
    printf("done!\n");
}