#include "cacheutils.h"

#include <cstdint>
#include <cstdio>
#include <cstring>
#include <pthread.h>
#include <setjmp.h>
#include <signal.h>

// definition of a Page Table Entry with all the required fields for foreshadow.
// DON'T add additional page table flags
struct PTE_t {
    uint64_t present : 1, : 11, page_ppn : 28;
} __attribute__((packed));

// length of the secret message
constexpr uint64_t NUMBER_CHARS = 18;

// use this external oracle for flush an reload
extern uint8_t volatile oracle[256 * 4096];

// the long jump buffer to recover from a seg-fault
// use longjmp and setjmp in this assignment
static jmp_buf longjump;

// host physical target PPN. This is the host physical ppn we want to leak
static uint64_t host_physical_target_ppn = 0x1234;

// We already recovered a guest virtual address to use as the foreshadow trigger
static uint8_t volatile *guest_trigger = (uint8_t volatile *)0x7f1234560000;

// the page table entry corresponding to the guest_trigger
extern PTE_t pte_of_guest_trigger;

// signal handler for the segfault
static void signal_handler(int signum) {
    // TODO use longjmp to recover from a seg-fault: (see: longjmp)
}

#define MIX_I(_x) ((((_x)*167) + 13) & 255)

// reuse your flush and reload implementation to determine the accessed oracle location
static char do_flush_and_reload() {

    // TODO: perform flush and reload on the oracle buffer to determine the accessed page
    // TODO: use the MIX_I macro to confuse the prefetcher and reduce the noise

    for ( uint64_t k = 0; k < 256; ++k ) {
        uint64_t i = MIX_I(k);

        if ( 0 /* TODO */ ) {
            return (char)i;
        }
    }
    return '.';
}

int main() {
    // local buffer for the recovered message
    char message[NUMBER_CHARS + 1] = {};

    // TODO: register the a signal handler for the signal 'SIGSEGV' (see: signal) and use the 'signal_handler' function as handler

    // TODO: use the provided guest PTE of the guest_trigger to setup the foreshadow page table mapping
    // TODO: use the provided host physical target address

    // iterate over each character
    for ( uint64_t i = 0; i < NUMBER_CHARS; ++i ) {

        // use setjump to perform a checkopoint
        if ( setjmp(longjump) == 0 ) {
            // TODO: to trigger foreshadow use the guest_trigger guest virtual address
            // TODO: implement foreshadow trigger access to the bytes of guest_trigger + i
            // TODO: linear encode (b * x) the leaked byte in the 'oracle'
        }

        // recover the character
        message[i] = do_flush_and_reload();
    }

    printf("%s\n", message);
    printf("done!\n");
}