# Zombieload

This exercise will implement a simple Zombieload attack in a simulated environment.
We assume that a victim program is actively performing accesses to secret data.

In the [main.cpp](main.cpp), we defined the address of tow mappings to a physical page: 'inaccessible_mapping' is a mapping over the kernel, 'accessible_mapping' is the mapping for the userspace and can be accessed.
Use these two mappings and construct the microarchitectural race condition to perform a Zombieload and leak the secret flag.
To recover from the seg-fault raised from the operating system due to the invalid access to the **simulated** kernel, we need to register a signal handler (see: `man signal`).
In the signal handler, use `setjmp` and `longjmp` functionality to continue with the next iteration of the loop, as already indicated in the skeleton.
Zombieload leaks additional noise irrelevant data. 
Therefore, use the first known byte of the secret to reconstruct the secret pice by pice and eliminate the noise where the previously leakage bytes are not matching.
Finally, we use a histogram to track how often a value was observed to remove additional **simulated** noise.
Note: We use the 0th entry in the oracle as a dummy value indicating that we observed noise.

Enter the recovered secret flag on EDX to get points.

To run this exercise, use the following command:
```
make
./main
```
