#include "cacheutils.h"

#include <algorithm>
#include <array>
#include <cstdint>
#include <cstdio>
#include <cstring>
#include <pthread.h>
#include <setjmp.h>
#include <signal.h>

// data type representing a histogram
using histogram_t = std::array<uint64_t, 256>;

// length of the secret message
constexpr uint64_t NUMBER_CHARS = 18;

// use this external oracle for flush an reload
extern uint8_t volatile oracle[256 * 4096];

// the long jump buffer to recover from a seg-fault
static jmp_buf longjump;

// the inaccessible mapping to a physical page
static uint8_t volatile *inaccessible_mapping = (uint8_t volatile *)0x7f1234560000;
// the accessible mapping to the same physical page
static uint8_t volatile *accessible_mapping = (uint8_t volatile *)0x7f1234450000;

// get the candidate form the histogram
static char get_best_candidate_except_zero(histogram_t const &histogram) {
    return (char)std::distance(histogram.begin(), std::max_element(histogram.begin() + 1, histogram.end()));
}

// clear the histogram
static void clear_histogram(histogram_t &histogram) {
    for ( auto &h : histogram )
        h = 0;
}

// signal handler for the segfault
static void signal_handler(int signum) {
    // TODO use longjmp to recover from a seg-fault: (see: longjmp)
}

#define MIX_I(_x) ((((_x)*167) + 13) & 255)

// reuse your flush and reload implementation to determine the accessed oracle loaction
static char do_flush_and_reload() {

    // TODO: perform flush and reload on the oracle buffer to determine the accessed page
    // TODO: use the MIX_I macro to confuse the prefetcher and reduce the nouse

    for ( uint64_t k = 0; k < 256; ++k ) {
        uint64_t i = MIX_I(k);

        if ( 0 /* TODO */ ) {
            return (char)i;
        }
    }
    return 0;
}

int main() {
    // local buffer for the recovered message
    char        message[NUMBER_CHARS + 1] = { '5' };
    histogram_t histogram;

    uint8_t last_v = message[0];

    // TODO: register the a signal handler for the signal 'SIGSEGV' (see: signal) and use the 'signal_handler' function as handler

    // iterate over each character
    for ( uint64_t i = 0; i < NUMBER_CHARS; ++i ) {
        clear_histogram(histogram);

        for ( uint64_t tries = 0; tries < 500; ++tries ) {

            // TODO: setup the zombieload condition by flushing the accessible mapping

            // use setjump to perform a checkpoint
            if ( setjmp(longjump) == 0 ) {
                // TODO: implement zombieload to the bytes of the inaccessible mapping to a physical page + i
                // TODO: include the already known byte, i.e., the last leaked byte

                uint16_t v = *(uint16_t *)(/*TODO*/);

                // TODO: check if the last leaked byte matches the already known one without if else statements
                int cor = /*TODO*/;

                // TODO: encode the upper byte of v in the oracle, only if the cor flag is set.
                // TODO: otherwise only access the zeroth element of the oracle (without if else)
                oracle[/*TODO*/];
            }

            // recover the character
            char recovered = do_flush_and_reload();
            histogram[recovered]++;
        }

        message[i] = get_best_candidate_except_zero(histogram);
        last_v     = message[i];
    }

    printf("%s\n", message);
    printf("done!\n");
}