# Fault Attacks

This exercise will implement a fault attack on AES-128 in a simulated environment.

The `./aes` program decrypts any 16 byte message you pass with a secret key.
The secret key is unknown and at the same time the flag you must recover.
You can recover the key by inducing a fault at the right time during an decryption and use the faulty output message to recover the key.
To induce the fault there is the `./simulator` program.
It takes the `aes.fault` file and induces faults at a specific memory address when the program is at a specific instruction.
With the supplied `aes.fault` file the first bit of every byte of the intermediate value is flipped when the program is at address `0x404e01`.
`0x404e01` is before the SubBytes step in the last round of AES.

There is already an `./exploit.py` script that contains basic code to call the `./aes` program with and without introducing a fault.
Your task is to take the outputs of correct runs and faulted runs and compute the key from these outputs.

Run the exploit script with:
```
./exploit.py
```