#!/usr/bin/env python3

import subprocess
import os
import sys
import os.path
import filecmp

import aes


def getPt(ct, fault=False):
    if fault:
        command = ['./simulator']
    else:
        command = ['./aes']
    command += [ct.hex()]
    sigprog = subprocess.Popen(command, bufsize=0, stdout=subprocess.PIPE, stderr=subprocess.PIPE, preexec_fn=os.setsid)
    stdout, stderr = sigprog.communicate(timeout=300)
    outlen = 16 * 2
    return bytes.fromhex(stdout[:outlen].decode('utf-8'))


# test if we have found the correct key by decrypting a random ct and testing the result
def check_challenge(k):
    randct = os.urandom(16)

    ptref = getPt(randct)
    dec = aes.AES(k)
    ptcheck = dec.decrypt_block(randct)

    if ptref == ptcheck:
        print('Challenge solved!')
        key_hex = k.hex()
        print('{SCS}-' + f'{key_hex[:8]}-{key_hex[8:12]}-{key_hex[12:16]}-{key_hex[16:20]}-{key_hex[20:]}')
    else:
        print('Challenge failed!')


def main():
    # fill this array with the recovered key
    k = bytearray(16)

    # you can query the AES decryption binary using the getPT function
    #  the "fault" parameter determines if you inject a fault in the execution
    ct = bytes.fromhex('00112233445566778899aabbccddeeff')
    real_pt = getPt(ct, False)
    faulty_pt = getPt(ct, True)

    # for your attack, you can use functions and tables from the included aes.py
    #  for instance, the Sbox can be computed as follows
    sbox_output = aes.s_box[ct[0]]

    ########################################################################
    # enter your code here


    ########################################################################

    check_challenge(k)


if __name__ == "__main__":
    sys.exit(main())
