# Platypus

This exercise will target a constant time password check with software-based power side channels.

In the [main.cpp](main.cpp), we specify a 20-character long password (including the zero byte) and have access to the `try_login` function.
However, this function uses a constant time algorithm to perform the password check:


```
size_t not_correct = 0;
for ( size_t i = 0; i < 20; ++i ) {
    uint64_t result = (pw[i] ^ secret[i]) * 0xffff;
    not_correct += result;
}
```

You aim to recover the login password and enter it on the EDX platform to get your points.

Note: We provide you with two functions, `start_energy_measurement` and `stop_energy_measurement`. These functions allow you to measure the **simulated** energy consumption of the instructions executed between these calls.
Hint: Think about when the shown password check requires more energy, if a character is correct, or if the character is incorrect.
Hint: Take a look at the hamming distance of the intermediate results.

To run this exercise, use the following command:
```
make
./main
```
